% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_matrices.R
\name{write_GRMBin}
\alias{write_GRMBin}
\title{Write GRM binary files.}
\usage{
write_GRMBin(X, n.snps = 0, prefix, size = 4)
}
\arguments{
\item{X}{Correlation matrix with rownames and colnames as sample IDs.}

\item{n.snps}{Number of SNPs used in correlation matrix calculation. Default is 0.0.}

\item{prefix}{Base file path and names for the three output files.}

\item{size}{Number of bytes to write for each value. Default is 4}
}
\value{
None. Though side effects are writing three files as described above.
}
\description{
Function to write a binary GRM format recently introduced by GCTA. It takes
a correlation matrix as used by other Kriging functions, and writes three
files: binary file for storing the diagonal + lower triangular elements, a
text file for sample IDs, and a binary file storing the number of SNPs used
in the correlation matrix calculation.
}
\examples{
  
  ## create a random genotype matrix
  nSamples <- 10
  mMarkers <- 100
  X <- matrix(rbinom(n=100, size=2, prob=0.5), nrow=nSamples)
  ## compute the Genetric Relatedness Matrix
  grm <- cor(X)
  ## write a Genetic Relatedness Matrix (GRM)
  ## NOTE: to following is not run here -- not writing any files in examples
  #write_GRMBin(grm, n.snps=mMarkers, prefix="grm.out")
}
\references{
http://www.complextraitgenomics.com/software/gcta/estimate_grm.html
}

