% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update.blrmfit}
\alias{update.blrmfit}
\title{Update data of a BLRM analysis}
\usage{
\method{update}{blrmfit}(object, ..., add_data)
}
\arguments{
\item{object}{blrmfit analysis object}

\item{...}{passed to default \code{update} command

The data in \code{add_data} will be combined with data in
\code{object} using \code{bind_rows}. The indices for groups and
stratums (if defined) are matched between \code{add_data} and the
data of the analysis \code{object}.

Note that the \code{add_data} argument must be named explicitly as
demonstrated in the example.}

\item{add_data}{additional data added to analysis data of \code{object}}
}
\description{
Adds data rows to a \code{\link{blrm_exnex}} or
\code{\link{blrm_trial}} analysis object.
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(
  OncoBayes2.MC.warmup = 10, OncoBayes2.MC.iter = 20, OncoBayes2.MC.chains = 1,
  OncoBayes2.MC.save_warmup = FALSE
)

example_model("single_agent", silent = TRUE)

library(tibble)
new_cohort <- tibble(group_id = "trial_A", drug_A = 50, num_patients = 4, num_toxicities = 1)

## this would fail, since add_data argument must be named
## new_blrmfit <- update(blrmfit, new_cohort)
new_blrmfit <- update(blrmfit, add_data = new_cohort)

## Recover user set sampling defaults
options(.user_mc_options)

}
