% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{PSAProstateCancer_df}
\alias{PSAProstateCancer_df}
\title{Factors associated with prostate specific antigen}
\format{
A data frame with 97 observations and 9 variables:
\describe{
  \item{lcavol}{Logarithm of cancer volume (numeric).}
  \item{lweight}{Logarithm of prostate weight (numeric).}
  \item{age}{Age of the patient in years (integer).}
  \item{lbph}{Logarithm of benign prostatic hyperplasia (numeric).}
  \item{svi}{Seminal vesicle invasion (integer).}
  \item{lcp}{Logarithm of cancer perineural invasion (numeric).}
  \item{gleason}{Gleason score (integer).}
  \item{pgg45}{Percentage of cancerous tissue with Gleason score 4 or 5 (integer).}
  \item{lpsa}{Logarithm of prostate specific antigen (PSA) (numeric).}
}
}
\source{
Data taken from the ncvreg package.
Based on data from Stamey et al. (1989), which examined the association between prostate specific antigen (PSA) and several clinical measures potentially associated with PSA in men about to receive a radical prostatectomy.
}
\usage{
data(PSAProstateCancer_df)
}
\description{
This dataset, PSAProstateCancer_df, is a data frame containing data from a study by Stamey et al. (1989) to examine the association between prostate specific antigen (PSA) and several clinical measures in men about to receive a radical prostatectomy. The dataset includes 97 observations and 9 variables, each representing a factor potentially associated with PSA.
}
\details{
The dataset name has been kept as 'PSAProstateCancer_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
