% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{SuspectedCancer_df}
\alias{SuspectedCancer_df}
\title{Suspected Cancer (SCAN) Pathway}
\format{
A data frame with 750 observations and 8 variables:
\describe{
  \item{age}{Age of the individual (numeric).}
  \item{comorbidity}{Comorbidity index (numeric).}
  \item{haemoglobin}{Haemoglobin level (numeric).}
  \item{albumin}{Albumin level (numeric).}
  \item{alaninetrans}{Alanine aminotransferase level (numeric).}
  \item{whitebloodcell}{White blood cell count (numeric).}
  \item{bilirubin}{Bilirubin level (numeric).}
  \item{calcium}{Calcium level (numeric).}
}
}
\source{
Data taken from the R4HCR package.
Nicholson BD, Oke JL, Friedemann Smith C, et al. The Suspected CANcer (SCAN) pathway: protocol for evaluating a new standard of care for patients with non-specific symptoms of cancer. BMJ Open 2018;8:e018168.
}
\usage{
data(SuspectedCancer_df)
}
\description{
This dataset, SuspectedCancer_df, is a data frame containing blood test results from individuals presenting with non-specific symptoms of cancer.
The data was collected as part of the Suspected CANcer (SCAN) pathway, which evaluates a new standard of care for patients in primary care settings.
}
\details{
The dataset name has been kept as 'SuspectedCancer_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
