% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_spec.R
\name{process_spec}
\alias{process_spec}
\alias{process_spec.default}
\alias{process_spec.OpenSpecy}
\title{Process Spectra}
\usage{
process_spec(x, ...)

\method{process_spec}{default}(x, ...)

\method{process_spec}{OpenSpecy}(
  x,
  active = TRUE,
  adj_intens = FALSE,
  adj_intens_args = list(type = "none"),
  conform_spec = TRUE,
  conform_spec_args = list(range = NULL, res = 5, type = "interp"),
  restrict_range = FALSE,
  restrict_range_args = list(min = 0, max = 6000),
  flatten_range = FALSE,
  flatten_range_args = list(min = 2200, max = 2420),
  subtr_baseline = FALSE,
  subtr_baseline_args = list(type = "polynomial", degree = 8, raw = FALSE, baseline =
    NULL),
  smooth_intens = TRUE,
  smooth_intens_args = list(polynomial = 3, window = 11, derivative = 1, abs = TRUE),
  make_rel = TRUE,
  make_rel_args = list(na.rm = TRUE),
  ...
)
}
\arguments{
\item{x}{an \code{OpenSpecy} object.}

\item{active}{logical; indicating whether to perform processing.
If \code{TRUE}, the processing steps will be applied.
If \code{FALSE}, the original data will be returned.}

\item{adj_intens}{logical; describing whether to adjust the intensity units.}

\item{adj_intens_args}{named list of arguments passed to
\code{\link{adj_intens}()}.}

\item{conform_spec}{logical; whether to conform the spectra to a new
wavenumber range and resolution.}

\item{conform_spec_args}{named list of arguments passed to
\code{\link{conform_spec}()}.}

\item{restrict_range}{logical; indicating whether to restrict the wavenumber
range of the spectra.}

\item{restrict_range_args}{named list of arguments passed to
\code{\link{restrict_range}()}.}

\item{flatten_range}{logical; indicating whether to flatten the range around
the carbon dioxide region.}

\item{flatten_range_args}{named list of arguments passed to
\code{\link{flatten_range}()}.}

\item{subtr_baseline}{logical; indicating whether to subtract the baseline
from the spectra.}

\item{subtr_baseline_args}{named list of arguments passed to
\code{\link{subtr_baseline}()}.}

\item{smooth_intens}{logical; indicating whether to apply a smoothing filter
to the spectra.}

\item{smooth_intens_args}{named list of arguments passed to
\code{\link{smooth_intens}()}.}

\item{make_rel}{logical; if \code{TRUE} spectra are automatically normalized
with \code{\link{make_rel}()}.}

\item{make_rel_args}{named list of arguments passed to
\code{\link{make_rel}()}.}

\item{na.rm}{Whether to allow NA or set all NA values to}

\item{\ldots}{further arguments passed to subfunctions.}
}
\value{
\code{process_spec()} returns an \code{OpenSpecy} object with processed
spectra based on the specified parameters.
}
\description{
\code{process_spec()} is a monolithic wrapper function for all spectral
processing steps.
}
\examples{
data("raman_hdpe")
plot(raman_hdpe)

# Process spectra with range restriction and baseline subtraction
process_spec(raman_hdpe,
             restrict_range = TRUE,
             restrict_range_args = list(min = 500, max = 3000),
             subtr_baseline = TRUE,
             subtr_baseline_args = list(type = "polynomial",
                                        polynomial = 8)) |>
  plot()

# Process spectra with smoothing and derivative
process_spec(raman_hdpe,
             smooth_intens = TRUE,
             smooth_intens_args = list(
               polynomial = 3,
               window = 11,
               derivative = 1
               )
             ) |>
  plot()

}
