% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addRecordings.R
\name{addRecordings}
\alias{addRecordings}
\alias{mapWavFolder}
\title{Add Recordings to an AcousticStudy Object}
\usage{
addRecordings(x, folder = NULL, log = FALSE, progress = TRUE)

mapWavFolder(folder = NULL, log = NULL, progress = TRUE)
}
\arguments{
\item{x}{a \linkS4class{AcousticStudy} object to add recordings to}

\item{folder}{a folder of recordings to add. If \code{NULL}, user will be
prompted to select a folder of recordings for each database present in
\code{x}. If a single folder, this will be applied to all databases. If
multiple folders, length must be equal to the number of databases and they
will be applied to each database in the provided order.}

\item{log}{(optional) log files for SoundTrap recordings. These are used to
adjust apparent lengths of recordings for missing data. If \code{NULL}, user
will be prompted to provide a folder (selecting no folder is a valid option here).
If \code{FALSE} this step will be skipped. If a single folder or multiple folders
will be applied similar to \code{folder}}

\item{progress}{logical flag to show progress bars}
}
\value{
the same object as \code{x} with recording information added
  to the \code{files} slots. The information added is a dataframe containing
  the start and end times of recording
}
\description{
Adds recording files to an AcousticStudy object, runs
  interactively to allow users to select files if they are not
  provided. No actual
  recordings are stored, a dataframe containing information on the
  start and end times of the recording files is added to the object.
}
\details{
\code{mapWavFolder} returns a dataframe of start and end
  times
}
\examples{

data(exStudy)
recs <- system.file('extdata', 'Recordings', package='PAMpal')
exStudy <- addRecordings(exStudy, folder=recs, log=FALSE, progress=FALSE)
files(exStudy)$recordings

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
