% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.r
\name{PCS_run_from_interconnections}
\alias{PCS_run_from_interconnections}
\title{Simulate the run of a PCS model based on only the interconnection matrix}
\usage{
PCS_run_from_interconnections(interconnection_matrix,
  convergence_criteria = c(PCS_convergence_McCandR),
  convergence_names = "default")
}
\arguments{
\item{interconnection_matrix}{A square, matrix representing the link weights
between nodes, such that each entry w_ij represents the link strength
between nodes i and j. Accordingly, for a network of n nodes, the matrix
must be of six n*n. In most applications, the matrix will be symmetric,
meaning that links are bidirectional.}

\item{convergence_criteria}{Array of convergence criteria to apply. This PCS
implementation allows users to define and observe multiple convergence
criteria in one model. Each entry in this array is a convergence criterion,
which is representated as a function that receives the current iteration,
energy, model state history and the \code{stability_criterion} defined
above and returns a boolean value representing whether the particular
criterion is met given the model's current state.}

\item{convergence_names}{Human-readable labels for the convergence criteria,
or \code{'default'}, in which case the criteria are numbered automatically,
in which case the criteria are numbered automatically.}
}
\description{
\code{PCS_run_from_interconnections} simulates a PCS network given
\emph{only} the pre-specified interconnection matrix and convergence
criteria, substituting default values from the literature for all other
parameters. Thereby, it provides a convenient shorthand for the
\code{\link{PCS_run}} function that covers the vast majority of applications.
}
\examples{

# Build interconnection matrix
interconnections <- matrix(
  c( 0.0000,  0.1015,  0.0470,  0.0126,  0.0034,  0.0000,  0.0000,
    0.1015,  0.0000,  0.0000,  0.0000,  0.0000,  0.0100, -0.0100,
    0.0470,  0.0000,  0.0000,  0.0000,  0.0000,  0.0100, -0.0100,
    0.0126,  0.0000,  0.0000,  0.0000,  0.0000,  0.0100, -0.0100,
    0.0034,  0.0000,  0.0000,  0.0000,  0.0000, -0.0100,  0.0100,
    0.0000,  0.0100,  0.0100,  0.0100, -0.0100,  0.0000, -0.2000,
    0.0000, -0.0100, -0.0100, -0.0100,  0.0100, -0.2000,  0.0000 ),
  nrow=7
  )

# Run model
result <- PCS_run_from_interconnections(interconnections)

# Examine iterations required for convergence
result$convergence

# Examine final model state
result$iterations[nrow(result$iterations),]

}

