% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{sparsity_count}
\alias{sparsity_count}
\title{sparsity_count}
\usage{
sparsity_count(Betas, lasso_group)
}
\arguments{
\item{Betas}{The coefficient of group lasso model.}

\item{lasso_group}{The group indicator for group lasso model}
}
\value{
An integer: The number of features used in group lasso
}
\description{
This function counts the number of features used in group lasso of PIE model.
}
\examples{
\donttest{
# Load the training data
data("winequality")

# Which columns are numerical?
num_col <- 1:11
# Which columns are categorical?
cat_col <- 12
# Which column is the response?
y_col <- ncol(winequality)

# Data Processing (the first 200 rows are sampled for demonstration)
dat <- data_process(X = as.matrix(winequality[1:200, -y_col]), 
  y = winequality[1:200, y_col], 
  num_col = num_col, cat_col = cat_col, y_col = y_col)

# Fit a PIE model
fold <- 1
fit <- PIE_fit(
  X = dat$spl_train_X[[fold]],
  y = dat$train_y[[fold]],
  lasso_group = dat$lasso_group,
  X_orig = dat$orig_train_X[[fold]],
  lambda1 = 0.01, lambda2 = 0.01, iter = 5, eta = 0.05, nrounds = 200
)

# Sparsity count
sparsity_count(fit$Betas, dat$lasso_group)
}
}
