test_that("merge regimens correctly", {
  reg1 <- new_regimen(amt = 1000, times = c(0, 24), type = "infusion", t_inf = 1)
  reg2 <- new_regimen(amt = 500, times = c(12, 36), type = "oral")
  reg3 <- merge_regimen(regimens = list(reg1, reg2))
  expect_equal(reg3$dose_times, c(0, 12, 24, 36))
  expect_equal(reg3$type, c("infusion", "oral", "infusion", "oral"))
  expect_equal(reg3$dose_amts, c(1000, 500, 1000, 500))
  expect_equal(reg3$t_inf, c(1, 0, 1, 0))
  expect_null(reg3$cmt)
})

test_that("merge regimens correctly: two infusions", {
  reg1 <- new_regimen(amt = 1000, times = c(0, 24), type = "infusion_1", t_inf = 1)
  reg2 <- new_regimen(amt = 500, times = c(12, 36), type = "infusion_2", t_inf = 2)
  reg3 <- merge_regimen(regimens = list(reg1, reg2))
  expect_equal(reg3$dose_times, c(0, 12, 24, 36))
  expect_equal(reg3$type, c("infusion_1", "infusion_2", "infusion_1", "infusion_2"))
  expect_equal(reg3$dose_amts, c(1000, 500, 1000, 500))
  expect_equal(reg3$t_inf, c(1, 2, 1, 2))
  expect_null(reg3$cmt)
})

test_that("cmt info gets merged as well, when available", {
  reg1 <- new_regimen(amt = 1000, times = c(0, 24), type = "infusion", t_inf = 1, cmt = 2)
  reg2 <- new_regimen(amt = 500, times = c(12, 36), type = "oral", cmt = 1)
  reg3 <- merge_regimen(regimens = list(reg1, reg2))
  expect_equal(reg3$dose_times, c(0, 12, 24, 36))
  expect_equal(reg3$type, c("infusion", "oral", "infusion", "oral"))
  expect_equal(reg3$dose_amts, c(1000, 500, 1000, 500))
  expect_equal(reg3$t_inf, c(1, 0, 1, 0))
  expect_equal(reg3$cmt, c(2, 1, 2, 1))
})
