% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balances.R
\name{abun_isometric_log_ratios}
\alias{abun_isometric_log_ratios}
\title{Compute isometric log ratio based on abundance of feature sets}
\usage{
abun_isometric_log_ratios(
  abun_table,
  set1_features,
  set2_features,
  pseudocount = NULL
)
}
\arguments{
\item{abun_table}{Abundance table, e.g., read counts or relative abundance.
Should be dataframe with column names correspond to sample names and row names corresponding to the feature ids.
No 0's are permitted unless the "pseudocount" option is set.}

\item{set1_features}{Features (rows of abundance table) that make up one side of the ratio to be computed (numerator).}

\item{set2_features}{Same as "set1_features", but for the other side of the ratio (denominator).}

\item{pseudocount}{Constant to add to all abundance values, to ensure that there are only non-zero values. For read count data this would typically be 1.}
}
\value{
Numeric vector of the computed isometric log ratio for each sample (where samples are taken to be each column in the input table).
}
\description{
Computes isometric log ratio between two sets of feature abundances, for each sample separately. Requires an abundance table,
with two sets of features for which the ratio will be computed.
}
