% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lms4.cv.R
\name{Lms4.cv}
\alias{Lms4.cv}
\title{Logarithmic minimum test for independence in four-way contingency table}
\usage{
Lms4.cv(nr, nc, nt, nu, n, alfa, B = 10000)
}
\arguments{
\item{nr}{a number of rows}

\item{nc}{a number of columns}

\item{nt}{a number of tubes}

\item{nu}{a number of tubes}

\item{n}{a sample size}

\item{alfa}{a significance level}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns the critical value of the logarithmic minimum test.
}
\description{
Calculates the critical value of the Logarithmic minimum test for independence in four-way contingency table
}
\details{
The Critical value of the Logarithmic minimum test for independence in r x c x t contingency table,
}
\examples{
Lms4.cv(2, 2, 2, 2, 160, 0.05, B = 1e2)
\donttest{Lms4.cv(2, 2, 2, 2, 160, 0.1, B = 1e3)}

}
\references{
Extension of the information contained in {Sulewski, P. (2021). \emph{Logarithmic Minimum Test for Independence in Three Way Con-tingency Table of Small Sizes,} Journal of Statistical Computation and Simulation 91(13), 2780-2799}
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
