% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psw_aug.R
\name{psw.aug}
\alias{psw.aug}
\title{Propensity score weighting with augmented estimation}
\usage{
psw.aug(data, form.ps, weight, form.outcome, family = "gaussian", K = 4)
}
\arguments{
\item{data}{data frame to be used.}

\item{form.ps}{propensity score model.}

\item{weight}{weighting method to be used. Available methods are \code{"ATE"},  \code{"ATT"}, \code{"ATC"}, \code{"MW"}, \code{"OVERLAP"}, and \code{"TRAPEZOIDAL"}.}

\item{form.outcome}{outcome model.}

\item{family}{outcome family, either \code{"gaussian"} or \code{"binomial"}. \code{family="gaussian"} by default.}

\item{K}{value of \eqn{K} in \eqn{\omega(e_i) = min(1, K min(e_i, 1-e_i)) } for \code{"TRAPEZOIDAL"} weight. The estimand is
closer to the average treatment effect (ATE) with larger value of \code{K}. \code{K=4} by default.}
}
\value{
A list of weighting method, fitted propensity score model, estimated propenstity scores, estimated propensity score weights,
augmented estimator and associated standard error.
\item{weight}{weighting method.}
\item{ps.model}{object returned by fitting the propensity score model using \code{glm} with \code{"binomial"} family.}
\item{ps.hat}{estimated propensity score.}
\item{W}{estimated propensity score weight.}
\item{est.aug}{augmented estimator for mean difference when \code{family = "gaussian"}.}
\item{std.aug}{standard error for \code{est.aug}.}
\item{est.risk.aug}{augmented estimator for risk difference when \code{family = "binomial"}.}
\item{std.risk.aug}{standard error for \code{est.risk.aug}.}
}
\description{
\code{psw.aug} is the function to estimate the augmented estimator for mean difference
(mean outcome difference for \code{"gaussian"} family and risk difference for \code{"binomial"} family).
The augmented estimator is consistent for the estimand defined by the corresponding propensity score model.
}
\details{
\code{psw.aug} is used to estimate the augmented estimator, \eqn{\hat{\Delta}_{aug}},
and make inference using the sandwich variance that adjusts for the sampling variability in the estimated propensity score.
}
\examples{
# Load the test data set
data(test_data);
# Propensity score model
form.ps <- "Z ~ X1 + X2 + X3 + X4";
# Outcome model
form.out <- "Y ~ X1 + X2 + X3 + X4";
tmp <- psw.aug( data = test_data, form.ps = form.ps, weight = "ATE",
form.outcome = form.out, family="gaussian" );

}
