% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PelegMSI.R
\name{PelegMSI}
\alias{PelegMSI}
\title{Peleg Moisture Sorption Isotherm}
\usage{
PelegMSI(WaterAct, AdsorpM, DesorpM)
}
\arguments{
\item{WaterAct}{the numerical value of Water Activity, which ranges from 0 to 1.}

\item{AdsorpM}{the numerical value of the Moisture content of the Adsorption curve, which ranges from 0 to 1.}

\item{DesorpM}{the numerical value of the Moisture content of the Desorption curve, which ranges from 0 to 1.}
}
\value{
the nonlinear regression, parameters, and graphical visualization for the Peleg Moisture Sorption Isotherm model.
}
\description{
Peleg model is an empirical 4-parameter isotherm which describes sigmoidal and non-sigmoidal behavior of isotherm plots.
}
\examples{
WaterAct <- c(0.1145,0.2274,0.3265,0.4291,0.6342,0.7385,0.8274,0.9573)
AdsorpM <- c(0.0234, 0.0366, 0.0496, 0.0648, 0.0887, 0.1096, 0.1343, 0.1938)
DesorpM <- c(0.0459, 0.0637, 0.0794, 0.0884, 0.1158, 0.1298,0.1500, 0.1938)
PelegMSI(WaterAct, AdsorpM, DesorpM)
}
\references{
Abu-Ghannam, N., & McKenna, B. (1997) <doi:10.1016/S0260-8774(97)00034-4> The application of Peleg's equation to model water absorption during the soaking of red kidney beans (Phaseolus vulgaris L.). Journal of Food Engineering, 32(4), 391-401.

Peleg, M. (1993) <doi:10.1111/j.1745-4530.1993.tb00160.x> Assessment of a semi-empirical four parameter general model for sigmoid moisture sorption isotherms. Journal of Food Process Engineering, 16(1), 21-37.
}
\author{
Benz L. Rivera

John Carlo F. Panganiban

Kim M. Villacorte

Chester C. Deocaris
}
