% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mswhimScores.R
\name{mswhimScores}
\alias{mswhimScores}
\title{Compute the MS-WHIM scores of a protein sequence}
\usage{
mswhimScores(seq)
}
\arguments{
\item{seq}{An amino-acids sequence}
}
\value{
The computed average of MS-WHIM scores of all the amino acids in the corresponding peptide sequence.
}
\description{
MS-WHIM scores were derived from 36 electrostatic potential properties derived from the three-dimensional structure of the 20 natural amino acids
}
\examples{
mswhimScores(seq = "KLKLLLLLKLK")
# [[1]]
#  MSWHIM1    MSWHIM2    MSWHIM3 
# -0.6563636  0.4872727  0.1163636 
}
\references{
Zaliani, A., & Gancia, E. (1999). MS-WHIM scores for amino acids: a new 3D-description for peptide QSAR and QSPR studies. Journal of chemical information and computer sciences, 39(3), 525-533.
}
