% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPESE.control.R
\name{RPESE.control}
\alias{RPESE.control}
\title{Controls Function for the Computation of Standard Errors for Risk and Performance estimators}
\usage{
RPESE.control(
  estimator = c("Mean", "SD", "VaR", "ES", "SR", "DSR", "SoR", "ESratio", "VaRratio",
    "SoR", "LPM", "OmegaRatio", "SemiSD", "RachevRatio")[1],
  se.method = NULL,
  cleanOutliers = NULL,
  fitting.method = NULL,
  freq.include = NULL,
  freq.par = NULL,
  a = NULL,
  b = NULL
)
}
\arguments{
\item{estimator}{Risk or performance estimator used to set default control parameters. Default is "Mean" estimator.}

\item{se.method}{A character string indicating which method should be used to compute
the standard error of the estimated standard deviation. One or a combination of:
\code{"IFiid"} (default), \code{"IFcor"} (default), \code{"IFcorPW"}, \code{"IFcorAdapt"},
\code{"BOOTiid"} or \code{"BOOTcor"}.}

\item{cleanOutliers}{Boolean variable to indicate whether the pre-whitenning of the influence functions TS should be done through a robust filter.}

\item{fitting.method}{Distribution used in the standard errors computation. Should be one of "Exponential" (default) or "Gamma".}

\item{freq.include}{Frequency domain inclusion criteria. Must be one of "All" (default), "Decimate" or "Truncate."}

\item{freq.par}{Percentage of the frequency used if \code{"freq.include"} is "Decimate" or "Truncate." Default is 0.5.}

\item{a}{First adaptive method parameter.}

\item{b}{Second adaptive method parameter.}
}
\value{
A list of different control parameters for the computation of standard errors.
}
\description{
\code{RPESE.controls} sets the different control parameters used in 
the compuation of standard errors for risk and performance estimators.
}
\examples{
# Case where we want the default parameters for the ES
ES.control <- RPESE.control(estimator="ES")
# Case where we also set additional parameters manually
ES.control.2 <- RPESE.control(estimator="ES", se.method=c("IFcor", "BOOTiid"),
                              cleanOutliers=TRUE, freq.include="Decimate")
# These lists can be passed onto the functions (e.g., ES) to control the parameters
# for computing and returning standard errors.

}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
