% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{probGen2expGen}
\alias{probGen2expGen}
\title{Compute expected genotypes from genotype probabilities.}
\usage{
probGen2expGen(probGeno)
}
\arguments{
\item{probGeno}{Vector [numeric] with genotype probabilites; has to be a
multiple of 3.}
}
\value{
Numeric vector of length [length(probGeno)/3] with the expected 
genotype value per individual.
}
\description{
Convert genotypes encoded as triplets of probablities (p(AA), p(Aa), p(aa))
into their expected genotype frequencies by 0*p(AA) + p(Aa) + 2p(aa).
}
\examples{
nrSamples <- 10
# Construct genotype probability vector (usually from external input)
# First, assign zero probabilty of AA, Aa and aa for all samples
genotype_prob <- rep(0, 3*nrSamples)
# Second, for each sample draw one of 0,1,2 (corresponding to AA, Aa and aa)
genotype_prob[seq(1, nrSamples*3, 3) + sample(0:2, 10, replace=TRUE)] <- 1
genotype_exp <- probGen2expGen(genotype_prob)
}
