% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsImmunogenicitySample.R
\name{ImmunogenicitySubset}
\alias{ImmunogenicitySubset}
\title{Immunogenicity subset}
\usage{
ImmunogenicitySubset(diseased, 
                     nondiseased, 
                     method = list(name = "Full", value = NA))
}
\arguments{
\item{diseased}{\code{Population-class} object: diseased subjects with assigned vaccination status}

\item{nondiseased}{\code{Population-class} object: non-diseased subjects with assigned vacination status}

\item{method}{named list: a selected method for creating the immunogenicity subset

method$name

\itemize{
  \item Full: subject level titer information is available for all diseased and all non-diseased subjects, i.e. immunogenicity subset is the full clinical trial

  \item Ratio: subject level titer information is available for all diseased and some non-diseased subjects.

  \item Fixed: subject level titer information is available for all diseased and some non-diseased subjects.
}


method$value

\itemize{
  \item Full: value = NA; immunogenicity sample is the full clinical trial (non-diseased subset contains all non-diseased in the trial; diseased subset contains all disease cases in the trial)

  \item Ratio: value = number of non-diseased divided by number of diseased subjects; ratio of diseased vs. non-diseased subjects in the immunogenicity subset (non-diseased subset contains only non-diseased subjects, as the selection is done in the end of the study, when the disease status is known; diseased subset contains all disease cases in the trial)

  \item Fixed: value = size of the immunogenicity subset, pre-defined number of subjects assayed for titers independently of their future disease status (non-diseased subset could rarely contain some diseased subjects, as the selection is done at the enrollment and prior the knowledge of future disease status; diseased subset contains all disease cases in the trial)
}}
}
\value{
Immunogenicity subset with subject level information about vaccination status and disease status, provided in the form of \code{Population-class} object
}
\description{
Function creates the immunogenicity subset based on the chosen method.
}
\details{
The total immunogenicity subset consists of the diseased immunogenicity subset and non-diseased immunogenicity subset. 
For all three methods implemented, we assume that the diseased immunogenicity subset contains all disease cases in the trial.
Based on the chosen method, the the size of the non-diseaded immunogenicity subset can be derived as follows:

Size = number of subjects in the non-diseased immunogenicity subset

Titers = values of titers from which we want to sample in order to simulate the non-diseased immunogenicity subset

#Diseased = total number of diseased in the clinical trial

#Nondiseased = total number of non-diseased in the clinical trial

 \itemize{
  \item method$name = "Full"
  
  Size = #Nondiseased
  
  Titers = Nondiseased Titers 

  \item method$name = "Ratio"
  
  Size =  method$value * #Diseased
  
  Titers = Nondiseased Titers
  
  \item method$name = "Fixed"
  
  Size = method$value
  
  Titers = Nondiseased Titers + Diseased Titers
  
}
}
\examples{
## Example 1
# Data preparation
data(diseased)
data(nondiseased)

ImmunogenicitySubset(diseased,
                     nondiseased,
                     method = list(name = "Ratio",
                                   value = 4))

}
