% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPoDParameters.R
\name{PoDParamPointEstimation}
\alias{PoDParamPointEstimation}
\title{PoD curve point estimate}
\usage{
PoDParamPointEstimation(resultsPriorReset, 
                        titers = seq(from = 0, to = 20, by = 0.01), 
                        optim_titers = FALSE)
}
\arguments{
\item{resultsPriorReset}{named data frame ("pmax", "slope", "et50"): set of estimated PoD curve parameters before resetting the disease status; for further details see \code{PoDParamEstimation} function.}

\item{titers}{numeric vector: a grid of titers for PoD curve point estimate calculation}

\item{optim_titers}{logical: TRUE for a predefined sequence of titers}
}
\value{
paramsPointEstimate: named data frame of PoD curve parameters corresponding to the PoD curve point estimate
}
\description{
Function returns PoD curve parameters corresponding to the point estimate of PoD curve.
}
\details{
For each of estimated PoD curves in resultsPriorReset, the function values (probabilities of disease, PoD) for provided grid of titers are calculated.

Median of function values (PoDs) at each provided titer is calculated.

Subsequently, the PoD curve model is fitted to the median datapoins using \code{fitPoD} function, in order to get PoD curve parameters close to this median curve.
}
\examples{
## Data preparation
data(estimatedParameters)

## Example 1
# titers for which we want to optimize the functional values
titers <- seq(from = 0, to = 20, by = 0.01)

# Point estimate of PoD curve
PoDParamPointEstimation(estimatedParameters$resultsPriorReset, titers)

}
