% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPoDParameters.R
\name{fitPoD}
\alias{fitPoD}
\title{PoD curve: fitting function}
\usage{
fitPoD(params, TitersInput, CurveTitersMedian)
}
\arguments{
\item{params}{named data frame ("pmax", "slope", "et50"): provided PoD curve parameters}

\item{TitersInput}{numeric vector: provided titers}

\item{CurveTitersMedian}{numeric vector: provided PoD values}
}
\value{
negative RMSE
}
\description{
Function calculates the root mean squared error (RMSE) between provided PoD values and calculated PoD values. The latter are calculated using for provided titers and provided PoD curve parameters.

By using the input titers \code{PoDParamPointEstimation} function and median of the estimated set of PoD curve parameters (output of \code{PoDParamEstimation} function), the point estimate of PoD curve can be obtained (for details see \code{PoDParamPointEstimation} function).
}
\details{
\deqn{RMSE = \sqrt{\frac{\sum_{i}^{N} (PoD_{median}(titers) - PoD_{optimized}(titers))^2}{N}}}{ RMSE = sqrt( mean( (PoDmedian(titers) - PoDoptimized(titers))2 ) )}
}
\examples{
## Data preparation
data(estimatedParameters)
data(PoDParams)

## Example 1

# grid of titers
TitersInput <- seq(from = 0, to = 20, by = 0.01)

# for each estimated PoD curve calculate functional values
functionValues <- 
  matrix(NA, 
         nrow = nrow(estimatedParameters$resultsPriorReset), 
         ncol = length(TitersInput))

for (i in 1:nrow(estimatedParameters$resultsPriorReset)) { 
  functionValues[i,] <- PoD(TitersInput,
  pmax = estimatedParameters$resultsPriorReset[i,1], 
  et50 = estimatedParameters$resultsPriorReset[i,3], 
  slope = estimatedParameters$resultsPriorReset[i,2], adjustTiters = FALSE)
}

# functional values corresponding to the median of the estimated PoD curve parameters
CurveTitersMedian <- apply(functionValues, 2, median)

# squared error of CurveTitersMedian and functional values of "params" curve
fitPoD(PoDParams, TitersInput, CurveTitersMedian)

}
