% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.R
\name{pdr_optimize_df}
\alias{pdr_optimize_df}
\title{Optimize production and consumption parameters for pool dilution data}
\usage{
pdr_optimize_df(...)
}
\arguments{
\item{...}{Parameters to be passed on to \code{\link{pdr_optimize}}}
}
\value{
The output of \code{\link{pdr_optimize}} summarized in a data frame,
with one line per parameter estimates (\code{P}, \code{k},
\code{frac_P}, and/or \code{frac_k}).
}
\description{
Optimize production and consumption parameters for pool dilution data
}
\examples{
tm <- 0:5
m <- c(10, 8, 6, 5, 4, 3)
n <- c(1, 0.7, 0.6, 0.4, 0.3, 0.2)
m_prec <- 0.001
ap_prec <- 0.01
# Optimize values for P (production) and k (consumption)
pdr_optimize_df(time = tm, m, n, m_prec, ap_prec, P = 0.5, k = 0.3)
}
\seealso{
\code{\link{pdr_optimize}}
}
