% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_difference_vector.R
\name{create_difference_vector}
\alias{create_difference_vector}
\title{Create a Difference Vector}
\usage{
create_difference_vector(grp_1_data, grp_2_data, location = "median")
}
\arguments{
\item{grp_1_data}{A data frame where all columns are numeric, representing the first group of data.}

\item{grp_2_data}{A data frame where all columns are numeric, representing the second group of data.}

\item{location}{A string specifying the location measure to use for calculating differences. Must be either 'median' or 'mean'.}
}
\value{
A numeric vector representing the differences between the second group's location measure and the first group's location measure for each column.
}
\description{
This function calculates the difference between two groups of data based on a specified location measure (median or mean).
}
\details{
The function checks if the specified location measure is valid ('median' or 'mean'). It also checks if both groups of data are numeric and if they have the same size and column variables. Based on the location measure, it calculates the differences and returns them as a numeric vector.
}
\examples{
df_1 <- data.frame(v1 = c(1, 2, 100),v2 = c(4, 5, 6))
df_2 <- data.frame(v1 = c(7, 6, 5),v2 = c(4, 3, 2))

create_difference_vector(df_2, df_1, 'median')
create_difference_vector(df_2, df_1, 'mean')

}
