% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findbeta_abstract.R
\name{findbeta_abstract}
\alias{findbeta_abstract}
\title{The findbeta (abstract) function}
\usage{
findbeta_abstract(themean.cat, thevariance.cat,
seed=280385, nsims=10000)
}
\arguments{
\item{themean.cat}{specify your prior belief about the mean. It takes a value among c("Very low","Low","Average","High","Very high").}

\item{thevariance.cat}{specify your prior belief about the variance. It takes a value among c("Very low","Low","Average","High","Very high").}

\item{seed}{A fixed seed for replication purposes.}

\item{nsims}{Number of simulations for the creation of various summary metrics of the elicited prior.}
}
\value{
parameters: The beta distribution parameters Beta(a,b)

summary: A basic summary of the elicited prior

input: The initial input value that produced the above prior.
}
\description{
A function to estimate the parameters alpha and beta of a Beta distribution based on the existing prior beliefs (data and/or expert opinion).
General information should be provided on the mean in terms of c("Very low","Low","Average","High","Very high"). The same holds for the variance parameter.
}
\examples{
## Example 1
## Based on the available literature the mean value for the sensitivity of a test
## is expected to be generally low and its variance not that low but not that much neither.

findbeta_abstract(themean.cat = "Low", thevariance.cat = "Average")

}
\references{
Branscum, A. J., Gardner, I. A., & Johnson, W. O. (2005): Estimation of diagnostic test sensitivity and specificity through Bayesian modeling. Preventive veterinary medicine, \bold{68}, 145--163.
}
