% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pro.sgpv.R
\name{pro.sgpv}
\alias{pro.sgpv}
\title{\code{pro.sgpv} function}
\usage{
pro.sgpv(
  x,
  y,
  stage = c(1, 2),
  family = c("gaussian", "binomial", "poisson", "cox"),
  gvif = F
)
}
\arguments{
\item{x}{Independent variables, can be a \code{matrix} or a \code{data.frame}}

\item{y}{Dependent variable, can be a \code{vector} or a column from a \code{data.frame}}

\item{stage}{Algorithm indicator. 1 denotes the one-stage algorithm and
2 denotes the two-stage algorithm. Default is 2. When \code{n} is less than \code{p},
only the two-stage algorithm is available.}

\item{family}{A description of the error distribution and link function to be
used in the model. It can take the value of \verb{\code{gaussian}}, \verb{\code{binomial}},
\verb{\code{poisson}}, and \verb{\code{cox}}. Default is \verb{\code{gaussian}}}

\item{gvif}{A logical operator indicating whether a generalized variance inflation factor-adjusted
null bound is used. Default is FALSE. See Fox (1992) \doi{10.1080/01621459.1992.10475190}
for more details on how to calculate GVIF}
}
\value{
A list of following components:
\describe{
\item{var.index}{A vector of indices of selected variables}
\item{var.label}{A vector of labels of selected variables}
\item{lambda}{\code{lambda} selected by generalized information criterion in the two-stage algorithm. \code{NULL} for the one-stage algorithm}
\item{x}{Input data \code{x}}
\item{y}{Input data \code{y}}
\item{family}{\code{family} from the input}
\item{stage}{\code{stage} from the input}
\item{null.bound}{Null bound in the SGPV screening}
\item{pe.can}{Point estimates in the candidate set}
\item{lb.can}{Lower bounds of CI in the candidate set}
\item{ub.can}{Upper bounds of CI in the candidate set}
}
}
\description{
This function outputs the variable selection results
from either one-stage algorithm or two-stage algorithm.
}
\examples{

# prepare the data
x <- t.housing[, -ncol(t.housing)]
y <- t.housing$V9

# run ProSGPV in linear regression
out.sgpv <- pro.sgpv(x = x, y = y)

# More examples at https://github.com/zuoyi93/ProSGPV/tree/master/vignettes
}
\seealso{
\itemize{
\item \code{\link[=print.sgpv]{print.sgpv()}} prints the variable selection results
\item \code{\link[=coef.sgpv]{coef.sgpv()}} extracts coefficient estimates
\item \code{\link[=summary.sgpv]{summary.sgpv()}} summarizes the OLS outputs
\item \code{\link[=predict.sgpv]{predict.sgpv()}} predicts the outcome
\item \code{\link[=plot.sgpv]{plot.sgpv()}} plots variable selection results
}
}
