#' Mortality Data for Poland
#'
#' Mortality data for Poland. Based on http://www.mortality.org/ database.
#' The subsequent columns describe:
#' \itemize{
#' \item Year. Year or range of years (for both period and cohort data)
#' \item Age. Age group for n-year interval from exact age x to just before exact age x+n, where n=1, 4, 5, or infinity (open age interval)
#' \item m(x). Central death rate between ages x and x+n
#' \item q(x). Probability of death between ages x and x+n
#' \item a(x). Average length of survival between ages x and x+n for persons dying in the interval
#' \item l(x). Number of survivors at exact age x, assuming l(0) = 100,000
#' \item d(x). Number of deaths between ages x and x+n
#' \item L(x). Number of person-years lived between ages x and x+n
#' \item T(x). Number of person-years remaining after exact age x
#' \item e(x). Life expectancy at exact age x (in years)
#' }
#'
#' Find more at http://www.mortality.org/Public/ExplanatoryNotes.php#CompleteDataSeries
#'
#' @docType data
#' @keywords datasets
#' @name przezycia
#' @examples
#' library("Przewodnik")
#' summary(przezycia)
#' @usage data(przezycia)
#' @format a data.frame with 11544 rows and 11 columns
#'
NULL
