% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sensors_data.R
\name{get_sensors_data}
\alias{get_sensors_data}
\title{Get Sensors Data}
\usage{
get_sensors_data(
  x,
  fields,
  location_type = c("both", "inside", "outside"),
  max_age = as.integer(604800),
  purple_air_api_key = Sys.getenv("PURPLE_AIR_API_KEY"),
  read_keys = NULL
)
}
\arguments{
\item{x}{an input object used to define multiple sensors:
\itemize{
\item an integer (or numeric or character) vector will select sensors based on \code{sensor_index} (API: \code{show_only})
\item a st_bbox object will select sensors geographically (API: \code{nwlat}, \code{nwlon}, \code{selat}, \code{selon})
\item a POSIXct object will select sensors modified since the given time (API: \code{modified_since})
}}

\item{fields}{A character vector of which 'sensor data fields' to return}

\item{location_type}{character; restrict to only "outside" or "inside" sensors (Outside: 0, Inside: 1)}

\item{max_age}{integer; filter results to only include sensors modified or updated within the last number of seconds}

\item{purple_air_api_key}{Your PurpleAir API \code{READ} key}

\item{read_keys}{A character vector of keys required to read data from private devices}
}
\value{
A list of sensor data, named by the provided \code{fields}
}
\description{
Retrieves the latest data of multiple sensors matching the provided parameters.
Find more details on sensor fields at https://api.purpleair.com/#api-sensors-get-sensors-data.
}
\examples{
\dontrun{
# get sensors data by integer, numeric, or character vector of `sensor_index`
get_sensors_data(
  x = as.integer(c(175257, 175413)),
  fields = c("name", "last_seen", "pm2.5_cf_1", "pm2.5_atm")
)
get_sensors_data(
  x = c(175257, 175413),
  fields = c("name", "last_seen", "pm2.5_cf_1", "pm2.5_atm")
)
get_sensors_data(
  x = c("175257", "175413"),
  fields = c("name"), location_type = "outside"
)
# get sensors by bounding box around Hamilton County, OH
sf::st_bbox(c("xmin" = -84.82030, "ymin" = 39.02153,
              "xmax" = -84.25633, "ymax" = 39.31206),
            crs = 4326) |>
  get_sensors_data(fields = c("name"))
# sensors modified in the last 60 seconds
get_sensors_data(as.POSIXct(Sys.time()) - 60, fields = "name")
}
}
\seealso{
get_sensor_data
}
