% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gigwa.R
\name{gigwa_set_project}
\alias{gigwa_set_project}
\title{Set the Current Active GIGWA Project}
\usage{
gigwa_set_project(project_name)
}
\arguments{
\item{project_name}{The name of the project to set as active.}
}
\value{
No return value. Updates the internal state with the selected project.
}
\description{
Select a project from the active GIGWA database and set it as the current active project
in the internal state. This selection is used for retrieving related data, such as runs or samples.
}
\examples{
if (interactive()) {
  set_qbms_config("https://gigwa.southgreen.fr/gigwa/", 
                  time_out = 300, engine = "gigwa", no_auth = TRUE)
  gigwa_set_db("Sorghum-JGI_v1")
  gigwa_set_project("Nelson_et_al_2011")
}
}
\seealso{
\code{\link{set_qbms_config}}, \code{\link{gigwa_set_db}}, \code{\link{gigwa_list_projects}}
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
