% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Qindex.R
\docType{class}
\name{Qindex}
\alias{Qindex}
\alias{Qindex-class}
\alias{Qindex_prefit_}
\title{Sign-Adjusted Quantile Indices}
\usage{
Qindex(formula, data, sign_prob = 0.5, ...)

Qindex_prefit_(formula, data, family, nonlinear = FALSE, ...)
}
\arguments{
\item{formula}{\link[stats]{formula}, e.g., \code{y~X}.
Response \eqn{y} may be \link[base]{double}, \link[base]{logical} and \link[survival]{Surv}.
Functional predictor \eqn{X} is a tabulated \link[base]{double} \link[base]{matrix};
the rows of \eqn{X} correspond to the subjects,
while the columns of \eqn{X} correspond to a \emph{common tabulating grid} shared by all subjects.
The \link[base]{numeric} values of the grid are in the \link[base]{colnames} of \eqn{X}}

\item{data}{\link[base]{data.frame}, must be a returned object from function \link{clusterQp}}

\item{sign_prob}{\link[base]{double} scalar between 0 and 1,
user-specified probability \eqn{\tilde{p}}
for the nearest-even \link[stats]{quantile} in the grid,
which is used to determine the \link[base]{sign}-adjustment.
Default is \code{.5}, i.e., the nearest-even \link[stats]{median} of the grid}

\item{...}{additional parameters for functions \link[mgcv]{s} and \link[mgcv]{ti},
most importantly \code{k}}

\item{family}{\link[stats]{family} object,
see function \link[mgcv]{gam}.
Default values are
\itemize{
\item \code{mgcv::cox.ph()} for \link[survival]{Surv} response \eqn{y};
\item \code{binomial(link = 'logit')} for \link[base]{logical} response \eqn{y};
\item \code{gaussian(link = 'identity')} for \link[base]{double} response \eqn{y}
}}

\item{nonlinear}{\link[base]{logical} scalar,
whether to use nonlinear or linear functional model.
Default \code{FALSE}}
}
\value{
Function \link{Qindex} returns an \linkS4class{Qindex} object,
which is an instance of an \link[base]{S4} class.
See section \strong{Slots} for details.
}
\description{
Sign-adjusted quantile indices
based on linear and/or nonlinear functional predictors.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{\link[base]{double} \link[base]{vector},
sign-adjusted quantile indices, see section \strong{Details} of function \link{integrandSurface}}

\item{\code{formula}}{see section \strong{Arguments}, parameter \code{formula}}

\item{\code{gam}}{a \link[mgcv]{gam} object}

\item{\code{gpf}}{a \code{'gam.prefit'} object, which is the returned object
from function \link[mgcv]{gam} with argument \code{fit = FALSE}}

\item{\code{p.value}}{\link[base]{numeric} scalar,
\eqn{p}-value for the test of significance of the functional predictor,
based on slot \verb{@gam}}

\item{\code{sign}}{\link[base]{double} scalar of either 1 or -1,
\link[base]{sign}-adjustment, see section \strong{Details} of function \link{integrandSurface}}

\item{\code{sign_prob}}{\link[base]{double} scalar, section \strong{Arguments}, parameter \code{sign_prob}}
}}

\examples{
# see ?`Qindex-package`
}
