% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_br23.R
\name{surv_br23}
\alias{surv_br23}
\title{Dataset contains survival outcomes and quality of life for breast cancer patients}
\usage{
surv_br23(x)
}
\arguments{
\item{x}{A data frame with ID, time, event, arm, BR_Q31,BR_Q32,...,BR_Q53 columns along with other columns if data is available.}
}
\value{
A data frame containing the Hazard Ratio(HR), Lower 95% CI and Upper 95% CI, for each of the covariates.
}
\description{
Creates a dataset containing the domain-based relative hazard ratio (95% CI) using
the arm-wise data from QLQ-BR23
}
\details{
Calculates the domain-wise relative hazard ratio (95% CI) using the arm-wise data from QLQ-BR23

surv_br23 function inputs either a dataset containing missing information, represented as,
9 or 99 or NA or a data not containing any missing information. It passes the data to the brc_qol()
function, which in turn gives the domain-wise scale scores. These domain-wise scale scores are used
for calculating the relative hazard ratio (95% CI) by first computing the hazard ratios by dividing
the data arm-wise.

The surv_br23 function includes the brc_qol() function which will consider the arm-wise data and
calculate the domain-wise scale scores. Hence, two set of domain-wise scale scores will be obtained,
one for each arm.

Each of the domain-wise scales, 'BRBI','BRSEF','BRSEE','BRFU','BRST','BRBS','BRAS','BRHL', are considered
as the covariates. Using these columns, Cox-Proportional model will be used for univariate analysis for
each of the covariates. The hazard ratio (95% CI) obtained for each arm is used to find out the relative hazard ratio (95% CI).

Thus, the output will contain three columns, Hazard Ratio(HR), Lower 95% CI and Upper 95% CI, for each of the covariates.

surv_br23(x)

1) Subject ID column should be named as 'ID'.

2) Each question column should be named as 'BR_Q31' for data from question 31,'BR_Q32' for data from question 32, and so on until 'BR_Q53' for data from question 53.

3) Data must contain columns for 'time', 'event' and 'arm'.

4) Data may contain more variables, such as, Age, Gender, etc.

x - A data frame with ID, time, event, arm, BR_Q31,BR_Q32,...,BR_Q53 columns along with other columns if data is available.
}
\examples{
##
data(brc_df)
surv_br23(brc_df)
##

}
\references{
QoLMiss: Package for Repeatedly measured Quality of Life of Cancer Patients Data
}
\seealso{
https://github.com/apstat/QoLMiss-Package
}
\author{
Atanu Bhattacharjee and Ankita Pal
}
