% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_ov28.R
\name{surv_ov28}
\alias{surv_ov28}
\title{Dataset contains survival outcomes and quality of life for ovarian cancer patients}
\usage{
surv_ov28(x)
}
\arguments{
\item{x}{A data frame with ID, time, event, arm, OV_Q31,OV_Q32,...,OV_Q58 columns along with other columns if data is available.}
}
\value{
A data frame containing the Hazard Ratio(HR), Lower 95% CI and Upper 95% CI, for each of the covariates.
}
\description{
Creates a dataset containing the domain-based relative hazard ratio (95% CI) using
the arm-wise data from QLQ-OV28
}
\details{
Calculates the domain-wise relative hazard ratio (95% CI) using the arm-wise data from QLQ-OV28

surv_ov28 function inputs either a dataset containing missing information, represented as,
9 or 99 or NA or a data not containing any missing information. It passes the data to the ovc_qol()
function, which in turn gives the domain-wise scale scores. These domain-wise scale scores are used
for calculating the relative hazard ratio (95% CI) by first computing the hazard ratios by dividing
the data arm-wise.

The surv_ov28 function includes the ovc_qol() function which will consider the arm-wise data and
calculate the domain-wise scale scores. Hence, two set of domain-wise scale scores will be obtained,
one for each arm.

Each of the domain-wise scales, 'Abdominal_GI','Peripheral_Neuropathy','Hormonal','Body_Image',
'Attitude_to_Disease','Chemotherapy_side_effects','Other_Single_Items','Sexuality', are considered as
the covariates. Using these columns, Cox-Proportional model will be used for univariate analysis for each
of the covariates. The hazard ratio (95% CI) obtained for each arm is used to find out the relative hazard ratio (95% CI).

Thus, the output will contain three columns, Hazard Ratio(HR), Lower 95% CI and Upper 95% CI, for each of the covariates.

surv_ov28(x)

1) Subject ID column should be named as 'ID'.

2) Each question column should be named as 'OV_Q31' for data from question 31,'OV_Q32' for data from question 32, and so on until 'OV_Q58' for data from question 58.

3) Data must contain columns for 'time', 'event' and 'arm'.

4) Data may contain more variables, such as, Age, Gender, etc.

x - A data frame with ID, time, event, arm, OV_Q31,OV_Q32,...,OV_Q58 columns along with other columns if data is available.
}
\examples{
##
data(ovc_df)
surv_ov28(ovc_df)
##

}
\references{
QoLMiss: Package for Repeatedly measured Quality of Life of Cancer Patients Data
}
\seealso{
https://github.com/apstat/QoLMiss-Package
}
\author{
Atanu Bhattacharjee and Ankita Pal
}
