% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardization.R
\name{get_baf}
\alias{get_baf}
\title{Calculate B-Allele Frequency (BAF) from Theta Values}
\usage{
get_baf(theta_subject, centers_theta, ploidy)
}
\arguments{
\item{theta_subject}{A numeric vector of theta values to be standardized. These typically
represent allelic ratios or normalized intensity values for a set of samples.}

\item{centers_theta}{A numeric vector of length `ploidy + 1`, representing the estimated
cluster centers (centroids) for each genotype class. These values should be sorted in
increasing order from homozygous reference to homozygous alternative.}

\item{ploidy}{An integer indicating the ploidy level of the organism (e.g., `2` for diploid).}
}
\value{
A numeric vector of BAF values ranging from 0 to 1
}
\description{
This function calculates the B-allele frequency (BAF) from normalized theta values,
using cluster centers that represent genotype classes. BAF is computed by linearly
interpolating the theta values between adjacent genotype cluster centroids.
}
\details{
The approach is based on the methodology described by Wang et al. (2007), and is
commonly used in SNP genotyping to infer allele-specific signal intensities.
}
\note{
The `centers_theta` vector must contain exactly `ploidy + 1` values, and must be
sorted in ascending order. If `theta_subject` values fall outside the range, BAFs are
capped at 0 or 1 accordingly.
}
\examples{
theta <- c(0.1, 0.35, 0.6, 0.95)
centers <- c(0.1, 0.5, 0.9)
get_baf(theta, centers, ploidy = 2)

}
\references{
Wang, K., Li, M., Hadley, D., Liu, R., Glessner, J., Grant, S. F. A., Hakonarson, H., & Bucan, M. (2007). PennCNV: An integrated hidden Markov model designed for high-resolution copy number variation detection in whole-genome SNP genotyping data. \emph{Genome Research, 17}(11), 1665–1674. \doi{10.1101/gr.6861907}
}
