% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPlate.R
\name{PlotPlate}
\alias{PlotPlate}
\title{Plot Time Series Data}
\usage{
PlotPlate(raw, plate_time, format = 96, f_size = 5, fill = FALSE)
}
\arguments{
\item{raw}{A data frame containing the raw plate data. The first row and
first two columns are assumed to be metadata and are removed.}

\item{plate_time}{Output from \code{ConvertTime()}.}

\item{format}{Format of plates used in the experiment. 96 or 384.}

\item{f_size}{font size for subtitles.}

\item{fill}{Logical, whether to fill in missing wells with 0. Default is FALSE.}
}
\value{
A ggplot object representing the plate data.
}
\description{
This function creates a faceted plot of time series data for each well in a plate layout.
}
\examples{
# Define the path to the plate data file
plate_path <- system.file("extdata/20240716_p3", 
                          file = '20240716_p3_plate.xlsx', 
                          package = "QuICSeedR")
  
# Read the plate data
plate <- readxl::read_xlsx(plate_path)

# Define the path to the raw data file
raw_path <- system.file("extdata/20240716_p3", 
                        file = '20240716_p3_raw.xlsx', 
                        package = "QuICSeedR")
# Read the raw data
raw <- readxl::read_xlsx(raw_path)

# Ensure time displayed as decimal hours
plate_time = ConvertTime(raw)

#Plot time series data for each well in a plate layout
PlotPlate(raw = raw, plate_time = plate_time, fill = TRUE)

}
