% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twosample_test.R
\name{twosample_test}
\alias{twosample_test}
\title{Tests for the univariate two-sample problem}
\usage{
twosample_test(
  x,
  y,
  vals = NA,
  TS,
  TSextra,
  wx = rep(1, length(x)),
  wy = rep(1, length(y)),
  B = 5000,
  nbins = c(50, 10),
  minexpcount = 5,
  maxProcessor,
  UseLargeSample,
  samplingmethod = "Binomial",
  rnull,
  SuppressMessages = FALSE,
  doMethods = "all"
)
}
\arguments{
\item{x}{a vector of numbers if data is continuous or of counts  if data is discrete or a list with the data}

\item{y}{a vector of numbers if data is continuous or of counts  if data is discrete.}

\item{vals}{=NA, a vector of numbers, the values of a discrete random variable. NA if data is continuous data.}

\item{TS}{routine to calculate test statistics for non-chi-square tests}

\item{TSextra}{additional info passed to TS, if necessary}

\item{wx}{A numeric vector of weights of x.}

\item{wy}{A numeric vector of weights of y.}

\item{B}{=5000, number of simulation runs for permutation test}

\item{nbins}{=c(50,10), number of bins for chi square tests.}

\item{minexpcount}{=5, minimum required expected counts for chi-square tests.}

\item{maxProcessor}{maximum number of cores to use. If missing (the default) no parallel processing is used.}

\item{UseLargeSample}{should p values be found via large sample theory if n,m>10000?}

\item{samplingmethod}{="Binomial" or "independence" for discrete data}

\item{rnull}{a function that generates data from a model, possibly with parameter estimation.}

\item{SuppressMessages}{= FALSE print informative messages?}

\item{doMethods}{="all" a vector of codes for the methods to include. If "all", all methods are used.}
}
\value{
A list of two numeric vectors, the test statistics and the p values.
}
\description{
This function runs a number of two sample tests using Rcpp and parallel computing.
}
\details{
For details consult vignette("R2sample","R2sample")
}
\examples{
 R2sample::twosample_test(rnorm(1000), rt(1000, 4), B=1000)
 myTS=function(x,y) {z=c(mean(x)-mean(y),sd(x)-sd(y));names(z)=c("M","S");z}
 R2sample::twosample_test(rnorm(1000), rt(1000, 4), TS=myTS, B=1000)
 vals=1:5
 x=table(sample(vals, size=100, replace=TRUE))
 y=table(sample(vals, size=100, replace=TRUE, prob=c(1,1,3,1,1)))
 R2sample::twosample_test(x, y, vals)
}
