% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBaseX.R, R/RbaseXClient.R
\docType{package}
\name{RBaseX}
\alias{RBaseX}
\alias{BasexClient}
\title{RBaseX}
\description{
'BaseX' is a robust, high-performance XML database engine and a highly compliant XQuery 3.1 processor
    with full support of the W3C Update and Full Text extensions.

The client can be used in 'standard' mode and in 'query' mode.
    Standard Mode is used for connecting to a server and sending commands.
}
\details{
'RBaseX' was developed using R6. For most of the public methods in the R6-classes, wrapper-functions
    are created. The differences in performance between R6-methods and wrapper-functions are minimal and
    slightly in advantage of the R6-version.

    It is easy to use the R6-calls instead of the wrapper-functions.
    The only important difference is that in order to execute a query, you have to call ExecuteQuery()
    on a queryObject.
}
\examples{
\dontrun{
    Session <- BasexClient$new("localhost", 1984L, username = "<username>", password = "<password>")
    Session$Execute("Check test")
    Session$Execute("delete /")
    # Add resource
    Session$Add("test.xml", "<root/>")

    # Bindings -----
    query_txt <- "declare variable $name external; for $i in 1 to 3 return element { $name } { $i }"
    query_obj <- Session$Query(query_txt)
    query_obj$queryObject$Bind("$name", "number")
    print(query_obj$queryObject$ExecuteQuery())
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BasexClient-new}{\code{BasexClient$new()}}
\item \href{#method-BasexClient-Command}{\code{BasexClient$Command()}}
\item \href{#method-BasexClient-Execute}{\code{BasexClient$Execute()}}
\item \href{#method-BasexClient-Query}{\code{BasexClient$Query()}}
\item \href{#method-BasexClient-Create}{\code{BasexClient$Create()}}
\item \href{#method-BasexClient-Add}{\code{BasexClient$Add()}}
\item \href{#method-BasexClient-put}{\code{BasexClient$put()}}
\item \href{#method-BasexClient-Replace}{\code{BasexClient$Replace()}}
\item \href{#method-BasexClient-putBinary}{\code{BasexClient$putBinary()}}
\item \href{#method-BasexClient-Store}{\code{BasexClient$Store()}}
\item \href{#method-BasexClient-set_intercept}{\code{BasexClient$set_intercept()}}
\item \href{#method-BasexClient-restore_intercept}{\code{BasexClient$restore_intercept()}}
\item \href{#method-BasexClient-get_intercept}{\code{BasexClient$get_intercept()}}
\item \href{#method-BasexClient-get_socket}{\code{BasexClient$get_socket()}}
\item \href{#method-BasexClient-set_success}{\code{BasexClient$set_success()}}
\item \href{#method-BasexClient-get_success}{\code{BasexClient$get_success()}}
\item \href{#method-BasexClient-clone}{\code{BasexClient$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-new"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new client-session
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$new(host, port = 1984L, username, password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host, port, username, password}}{Host-information and user-credentials}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-Command"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-Command}{}}}
\subsection{Method \code{Command()}}{
Execute a command
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Command(command)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Command}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For a list of database commands see \url{https://docs.basex.org/wiki/Commands}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-Execute"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-Execute}{}}}
\subsection{Method \code{Execute()}}{
Execute a command
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Execute(command)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Command}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For a list of database commands see \url{https://docs.basex.org/wiki/Commands}.
   This function is replaced by 'Command' and is obsolete.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-Query"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-Query}{}}}
\subsection{Method \code{Query()}}{
Create a new query-object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Query(query_string)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query_string}}{Query-string}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A query-object has two fields. 'queryObject' is an ID for the new created 'QueryClass'-instance.
    'success' holds the status from the last executed operation on the queryObject.
}

\subsection{Returns}{
ID for the created query-object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-Create"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-Create}{}}}
\subsection{Method \code{Create()}}{
Create a new database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Create(name, input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name}

\item{\code{input}}{Initial content, Optional}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initial content can be offered as string, URL or file.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-Add"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-Add}{}}}
\subsection{Method \code{Add()}}{
Add a new resouce at the specified path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Add(path, input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path}

\item{\code{input}}{File, directory or XML-string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-put"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-put}{}}}
\subsection{Method \code{put()}}{
Add or replace resource, adressed by path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$put(path, input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path}

\item{\code{input}}{File, directory or XML-string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-Replace"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-Replace}{}}}
\subsection{Method \code{Replace()}}{
Replace resource, adressed by path.
This function is deprecated and has been replaced by /'put/'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Replace(path, input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path}

\item{\code{input}}{File, directory or XML-string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-putBinary"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-putBinary}{}}}
\subsection{Method \code{putBinary()}}{
Store binary content
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$putBinary(path, input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path}

\item{\code{input}}{File, directory or XML-string}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Binary content can be retrieved by executing a retrieve-command
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-Store"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-Store}{}}}
\subsection{Method \code{Store()}}{
Store binary content
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Store(path, input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path}

\item{\code{input}}{File, directory or XML-string}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Binary content can be retrieved by executing a retrieve-command.
This function is deprecated and has been replaced by /'putBinary/'.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-set_intercept"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-set_intercept}{}}}
\subsection{Method \code{set_intercept()}}{
Toggles between using the ´success'-field, returned by the
    Execute-command or using regular error-handling (try-catch).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$set_intercept(Intercept)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Intercept}}{Boolean}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-restore_intercept"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-restore_intercept}{}}}
\subsection{Method \code{restore_intercept()}}{
Restore the Intercept Toggles to the original value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$restore_intercept()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-get_intercept"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-get_intercept}{}}}
\subsection{Method \code{get_intercept()}}{
Get current Intercept
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$get_intercept()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-get_socket"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-get_socket}{}}}
\subsection{Method \code{get_socket()}}{
Get the socket-ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$get_socket()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Socket-ID,
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-set_success"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-set_success}{}}}
\subsection{Method \code{set_success()}}{
Set the status success-from the last operation on the socket
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$set_success(Success)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Success}}{Boolean}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function is intended to be used by instances from the QueryClass
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-get_success"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-get_success}{}}}
\subsection{Method \code{get_success()}}{
Get the status success-from the last operation on the socket
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$get_success()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean,
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BasexClient-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BasexClient-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
