% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testmeansC.r
\name{testmeansC}
\alias{testmeansC}
\title{One and two-sample difference of means tests (t-tests) with confidence intervals.}
\usage{
testmeansC(x1, x2, w, data, dv, iv, digits = 2, var.equal = FALSE,
  paired = FALSE, pop.sd = FALSE, var.test = FALSE, printC = FALSE,
  ci.table = TRUE, ci.level = 95, ci.plot = TRUE, main, xlab, xlim, ...)
}
\arguments{
\item{x1}{The first variable to be compared (mean of x1 will be compared to mean of x2). Must be numeric variable. Should be in the form dataset$var, unless dataset specified with data argument.}

\item{x2}{The variable (or number) to which x1 is compared. Should be in the form dataset$var, unless dataset specified with data argument. You can set x2 equal to a number to conduct a one sample means test. For example, to test whether x1 could have population mean of 50, you'd set x2 = 50.}

\item{w}{(Optional) Weights variable (optional). Should be in the form dataset$var, unless dataset specified with data argument.}

\item{data}{(Optional) The dataset that contains x1, x1 and x2, or dv and iv.}

\item{dv}{The dependent variable. Must be numeric variable. Should be in the form dataset$var, unless dataset specified with data argument.}

\item{iv}{The independent variable. Should have two distinct values (like treatment and control). Should be in the form dataset$var, unless dataset specified with data argument.}

\item{digits}{(Optional) Number of digits to report after decimal place, optional (default: 3).}

\item{var.equal}{(Optional) With two-sample tests, do you want to assume equal variances? (default: FALSE)}

\item{paired}{(Optional) With two-sample tests, are the observations paired? (default: FALSE)}

\item{pop.sd}{(Optional) If the population standard deviation is known, you can specify it.}

\item{var.test}{(Optional) If set to TRUE, will test the assumption that two sample variance are equal using an F test. Default is FALSE. The var.test option implemented for both weighted and unweighted analysis. If you are not using sample weights, you can supplement this F test with additional tests such as \code{stats::bartlett.test} and \code{car::leveneTest}.}

\item{printC}{(Optional) Do you want results printed to .html file in your working directory? Default is FALSE. Set to TRUE to print results.}

\item{ci.table}{(Optional) Confidence level for calculating the confidence interval of the difference of means, defaults to 95. Set to F or FALSE to omit confidence interval from results.}

\item{ci.level}{(Optional) Desired confidence level, as percentage (default: 95)}

\item{ci.plot}{(Optional) Do you want a plot of the confidence interval of the difference of means? (default: TRUE)}

\item{main}{(Optional) Main title for plot of confidence interval of difference}

\item{xlab}{(Optional) Label for x-axis of plot of confidence interval of difference}

\item{xlim}{(Optional) A vector (of length 2) specifying the range of the x-axis, useful to zoom in on CI.}

\item{...}{(Optional) Additional arguments passed to \code{plot} function for the CI plot}
}
\value{
No return
}
\description{
Conducts one and two-sample difference of means tests (t-tests). Options for weighting observations, known population standard deviation, equal or unequal variances, paired observations.
}
\section{RCPA3 Package Tutorial Videos}{

\itemize{
\item \href{https://www.youtube.com/watch?v=K3sve6O77fY}{Testing Means with RCPA3 Package's testmeansC Function} 12:22
\item \href{https://www.youtube.com/playlist?list=PL3jY4WDTUxoNqrxSSQH4q7XPLPYipeNCu}{Complete Playlist of RCPA3 Package Tutorial Videos}, includes video for this function and many more.
}
}

\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapter 9.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp.201-215. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=9}{R Tutorials & Resources for Hypothesis Tests with One and Two Samples}, Compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}, find datasets for your own research and resources to help with the analysis.
}
}

\examples{
   library(RCPA3)
   
   \dontrun{ 
   # one sample test against hypothesized value
   testmeansC(x1=world$literacy, x2=80)
   
   # with x1 and x2 
   testmeansC(x1=ft.trump.post, x2=ft.pence.post, w=wt, data=nes)
   
   # with paired x1 and x2
   testmeansC(x1=nes$ft.pence.post, x2=nes$ft.pence.pre, w=nes$wt, paired=TRUE)

   # with dv and iv 
   testmeansC(dv=nes$ft.bigbiz, iv=nes$gender, w=nes$wt)
   }
}
