% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{LoadData}
\alias{LoadData}
\title{Load recruitment data.}
\usage{
LoadData(data, date, enrolled)
}
\arguments{
\item{data}{Main dataset containing at least two columns:
\itemize{
\item A \code{date} column with the calendar date of the screening
\item A \code{enrolled} column with the number of subjects enrolled
}

If the entries cover a period longer than 1 year, only the entries within \if{html}{\out{<br>}}
one year prior to the latest date will be retained.\if{html}{\out{<br>}}
\if{html}{\out{<br>}}}

\item{date}{The name (symbol or string) of the column in the dataset with the calendar\if{html}{\out{<br>}}
dates of active screening. All active calendar dates should be included, even\if{html}{\out{<br>}}
if the recruitment for that date is 0. Only dates with truly non-active\if{html}{\out{<br>}}
recruitment should be omitted. The date column must be:
\itemize{
\item an object inheriting from class the \code{Date} class
\item or a character vector with a valid date format.
}}

\item{enrolled}{The name (symbol or string) of the column in the dataset with the number of\if{html}{\out{<br>}}
subjects recruited on the corresponding calendar date. It must be a numeric vector.}
}
\value{
This function does not return any value. It runs several tests and proccesses\if{html}{\out{<br>}}
the data and stores internally the results. It prints a message to the console\if{html}{\out{<br>}}
if the data is successfully loaded  or an error message if there is an issue\if{html}{\out{<br>}}
with the input data. Once the dataset is loaded, the following functions can\if{html}{\out{<br>}}
be used:
\itemize{
\item \code{\link[=Time2Nsubjects]{Time2Nsubjects()}}: simulates the number of weeks needed to recruit a\if{html}{\out{<br>}}
given number of subjects
\item \code{\link[=GetDistance]{GetDistance()}}: calculates the Euclidean distance between the\if{html}{\out{<br>}}
predicted and actual recruitment
\item \code{\link[=GetWeekPredCI]{GetWeekPredCI()}}: calculates the median recruitment with 95\% CI for\if{html}{\out{<br>}}
up to the next 104 weeks (two years)
}
}
\description{
This function must be called before any other function in this package. LoadData\if{html}{\out{<br>}}
checks the input data and stores the results internally for the session.\if{html}{\out{<br>}}
Calling this function more than once in the same session will overwrite the\if{html}{\out{<br>}}
previously created internal data.
}
\examples{
# Load using names as symbols
LoadData(gripsYR1, ScreenDt, Enrolled)

# Load using names as strings
LoadData(gripsYR1, "ScreenDt", "Enrolled")

# Load using base pipe operator
gripsYR1 |> LoadData(ScreenDt, Enrolled)

# Load using magrittr pipe operator
if (base::requireNamespace("magrittr", quietly = TRUE)) {
  library(magrittr)
  gripsYR1 \%>\% LoadData(ScreenDt, Enrolled) 
}
}
\seealso{
Other Links: 
\code{\link{GetDistance}()},
\code{\link{GetWeekPredCI}()},
\code{\link{RCTRecruit-package}},
\code{\link{Time2Nsubjects}()},
\code{\link{gripsYR1}},
\code{\link{gripsYR2}},
\code{\link{gripsYR2Weekly}},
\code{\link{plot.RCTPredCI}()}
}
\concept{Links}
