# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Simplify a curve using the Ramer-Douglas-Peucker algorithm.
#'
#' Implements the [Ramer-Douglas-Peucker algorithm](https://en.wikipedia.org/wiki/Ramer-Douglas-Peucker_algorithm) for reducing the number of points on a curve.
#'
#' @details If there are no more than two points it does not make sense to simplify.
#' In this case the input is returned without further checks of `x` and `y`.
#' In particular, the input is not checked for `NA` values.
#'
#' @param x `[numeric]` The `x` values of the curve as a vector without `NA` values.
#' @param y `[numeric]` The `y` values of the curve as a vector without `NA` values.
#' @param epsilon `[positive numeric(1)]` The threshold for filtering outliers from the simplified curve.
#' @param keep_index `[logical]` If `TRUE`, returns a column called `index` with the index locations of points that are kept.
#'
#' @return A `data.frame` with `x` and `y` values of the simplified curve.
#'
#' @examples
#' RDP::RamerDouglasPeucker(x = c(0, 1, 3, 5), y = c(2, 1, 0, 1), epsilon = 0.5)
#' RDP::RamerDouglasPeucker(x = c(0, 1, 3, 5), y = c(2, 1, 0, 1), epsilon = 0.5, keep_index = TRUE)
#'
#' @export
#'
RamerDouglasPeucker <- function(x, y, epsilon, keep_index = FALSE) {
    .Call(`_RDP_RamerDouglasPeucker`, x, y, epsilon, keep_index)
}

