% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_league_listing.R
\name{get_league_listing}
\alias{get_league_listing}
\title{Information about DotaTV-supported leagues}
\usage{
get_league_listing(dota_id = 570, language = "en", key = NULL)
}
\arguments{
\item{dota_id}{Can take one of three values.

\itemize{
 \item 570 - Dota 2 (default)
 \item 816 - Dota 2 Internal Test
 \item 205790 - Dota 2 Beta Test
}}

\item{language}{The ISO639-1 language code for returning all the information in the corresponding
language. If the language is not supported, english will be returned. For a complete list of the
ISO639-1 language codes please visit \url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}.}

\item{key}{The api key obtained from Steam. If you don't have one please visit
\url{https://steamcommunity.com/dev} in order to do so. For instructions on the correct way
to use this key please visit \url{https://github.com/LyzandeR/RDota2} and check the readme file.
You can also see the examples. A key can be made available to all the functions by using
\code{key_actions}. The key argument in individual functions should only be used in case the
user needs to work with multiple keys.}
}
\value{
A dota_api object containing the elements described in the details.
}
\description{
Information about DotaTV-supported leagues.
}
\details{
A list will be returned that contains three elements. The content, the url and the response
received from the api.

The content is probably the most useful part for the user since it is a data.frame containing the
information about the DotaTV-supported leagues. It consists of the five following columns:
\itemize{
  \item \strong{name:} The league name.
  \item \strong{leagueid:} The ID of the league (unique).
  \item \strong{description:} A description containing information about the league.
  \item \strong{tournament_url:} The website of the link.
  \item \strong{itemdef:} Not documented on the API.
}
}
\section{Steam API Documentation}{

 \url{https://wiki.teamfortress.com/wiki/WebAPI/GetLeagueListing}
}
\examples{
\dontrun{
get_league_listing()
get_league_listing(language = 'en', key = NULL)
get_league_listing(language = 'en', key = 'xxxxxxxxxxx')
}

}

