#' Northport Data, \emph{Hyalella azteca} Toxicity
#'
#' Example dataset
#' 
#' @name h.northport
#' @docType data
#' @format A data.frame with 147 rows and 15 variables:
#' \describe{
#'   \item{Sample}{sediment sample ID}
#'   \item{Al}{aluminum concentration, mg/kg dry weight}
#'   \item{As}{arsenic concentration, mg/kg dry weight}
#'   \item{Cu}{copper concentration, mg/kg dry weight}
#'   \item{Cd}{cadmium concentration, mg/kg dry weight}
#'   \item{Cr}{chromium concentration, mg/kg dry weight}
#'   \item{Fe}{iron concentration, mg/kg dry weight}
#'   \item{Pb}{lead concentration, mg/kg dry weight}
#'   \item{Hg}{mercury concentration, mg/kg dry weight}
#'   \item{Ni}{nickel concentration, mg/kg dry weight}
#'   \item{Zn}{zinc concentration, mg/kg dry weight}
#'   \item{Organism}{organism abbreviation, \code{HA} = \emph{Hyalella azteca}}
#'   \item{Meas_Day}{measurement day for toxicity endpoint (post-initiation)}
#'   \item{Endpoint}{toxicity endpoint}
#'   \item{Hit}{logical; whether the sample was classified as toxic}
#' }
#' @details \code{h.northport} is a field-collected dataset containing sediment chemical concentrations for metals and toxicity classification data for
#' the amphipod \emph{Hyalella azteca}. Data are from a freshwater site in Washington State (Dowling and Roland 2019).
#' @references
#' Dowling B, Roland J. 2019. Establishment of site-specific SMS metals cleanup objectives for contaminated sediments - Northport waterfront and nearshore state cleanup site. Washington State Department of Ecology.
NULL