% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{.postRW}
\alias{.postRW}
\title{Draws from the posterior of the variance parameter of a random walk or a random walk with
constant or stochastic drift.}
\usage{
.postRW(Y, sigmaDistr, sigmaLast = NULL, muDistr = NULL)
}
\arguments{
\item{Y}{A \code{Tn x 1} vector with the dependent variable.}

\item{sigmaDistr}{A \code{1 x k} matrix with prior distribution and box constraints for
the innovation variance. The first two entries contain the prior hyperparameters and
the last two entries the upper and lower bound.}

\item{sigmaLast}{A scalar containing the last draw of the innovation variance.}

\item{muDistr}{A \code{k x 1} matrix with prior distribution and box constraints for
the constant trend. The first two entries contain the prior hyperparameters and
the last two entries the upper and lower bound.}
}
\description{
Draws from the posterior of the variance parameter of a random walk or a random walk with
constant or stochastic drift.
}
\details{
If the process follows a random walk with constant drift, the two parameters are
  drawn sequentially (conditional on the other parameter). The constant is drawn from a
  normal posterior given by conjugacy.

The innovation variance is drawn from a Inverse-Gamma posterior given by
conjugacy.
}
\keyword{internal}
