% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dense_matrix_kernels.R
\name{DeterminantMicrobenchmark}
\alias{DeterminantMicrobenchmark}
\title{Conducts a single performance trial with the matrix determinant dense
matrix kernel}
\usage{
DeterminantMicrobenchmark(benchmarkParameters, kernelParameters)
}
\arguments{
\item{benchmarkParameters}{an object of type
\code{\link{DenseMatrixMicrobenchmark}} specifying various parameters
for microbenchmarking the dense matrix kernel}

\item{kernelParameters}{a list of matrices or vectors to be used as input to
the dense matrix kernel}
}
\description{
\code{DeterminantMicrobenchmark} conducts a single performance trial of the
dense matrix determinant dense matrix kernel for the matrix given in the
\code{kernelParameters} parameter.  The function times the single function
call \code{determinant(kernelParameters$A)}.
}
\examples{
\dontrun{
# Allocate input to the matrix determinant microbenchmark for the first
# matrix size to be tested
microbenchmarks <- GetDenseMatrixDefaultMicrobenchmarks()
kernelParameters <- DeterminantAllocator(microbenchmarks[["determinant"]], 1)
# Execute the microbenchmark
timings <- DeterminantMicrobenchmark(microbenchmarks[["determinant"]], kernelParameters)
}

}
