/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.ElementaryTransformations;
import ec.tstoolkit.maths.matrices.IVectorTransformation;

public class GivensRotation
implements IVectorTransformation {
    private final int lentry_;
    private final int rentry_;
    private final double d_;
    private final double ro_;

    public GivensRotation(DataBlock vector, int lentry, int rentry) {
        double h;
        this.lentry_ = lentry;
        this.rentry_ = rentry;
        double a = vector.get(lentry);
        double b = vector.get(rentry);
        if (a != 0.0) {
            h = ElementaryTransformations.hypotenuse(a, b);
            this.ro_ = b / h;
            this.d_ = a / h;
        } else if (b < 0.0) {
            this.d_ = 0.0;
            this.ro_ = -1.0;
            h = -b;
        } else {
            this.d_ = 0.0;
            this.ro_ = 1.0;
            h = b;
        }
        vector.set(rentry, 0.0);
        vector.set(lentry, h);
    }

    public GivensRotation(DataBlock vector, int entry) {
        this(vector, 0, entry);
    }

    @Override
    public void transform(DataBlock vector) {
        double a = vector.get(this.lentry_);
        double b = vector.get(this.rentry_);
        vector.set(this.lentry_, this.d_ * a + this.ro_ * b);
        vector.set(this.rentry_, -this.ro_ * a + this.d_ * b);
    }
}

