% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilAnalyticalAucsRSM.R
\name{UtilAnalyticalAucsRSM}
\alias{UtilAnalyticalAucsRSM}
\title{RSM ROC/AFROC/wAFROC AUC calculator}
\usage{
UtilAnalyticalAucsRSM(mu, lambda, nu, zeta1 = -Inf, lesDistr, relWeights = 0)
}
\arguments{
\item{mu}{The mean of the Gaussian distribution for the 
ratings of latent LLs (continuous ratings of lesions that 
are found by the search mechanism). The NLs are assumed to be distributed
as N(0,1).}

\item{lambda}{The RSM lambda parameter.}

\item{nu}{The RSM nu parameters.}

\item{zeta1}{The lowest reporting threshold, the default is \code{-Inf}.}

\item{lesDistr}{The lesion distribution 1D array, i.e., the probability
mass function (pmf) of the numbers of lesions for diseased cases.}

\item{relWeights}{The relative weights of the lesions; a vector of 
length \code{maxLL}; if zero, the default, equal weights are assumed.}
}
\value{
A list containing the ROC, AFROC and wAFROC AUCs corresponding to the 
   specified parameters
}
\description{
{Returns the ROC, AFROC and wAFROC AUCs corresponding to 
   specified RSM parameters. See also \code{\link{UtilAucPROPROC}}, 
   \code{\link{UtilAucBinormal}} and \code{\link{UtilAucCBM}}}
}
\examples{
mu <- 1;lambda <- 1;nu <- 0.9
lesDistr <- c(0.9, 0.1) 
## i.e., 90\% of dis. cases have one lesion, and 10\% have two lesions
relWeights <- c(0.05, 0.95)
## i.e., lesion 1 has weight 5 percent while lesion two has weight 95 percent

UtilAnalyticalAucsRSM(mu, lambda, nu, zeta1 = -Inf, lesDistr)
UtilAnalyticalAucsRSM(mu, lambda, nu, zeta1 = -Inf, lesDistr, relWeights)


}
\references{
Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL. 
\url{https://www.routledge.com/Observer-Performance-Methods-for-Diagnostic-Imaging-Foundations-Modeling/Chakraborty/p/book/9781482214840}

Chakraborty DP (2006) A search model and figure of merit for observer data acquired according to the free-response 
paradigm, Phys Med Biol 51, 3449-3462.

Chakraborty DP (2006) ROC Curves predicted by a model of visual search, Phys Med Biol 51, 3463--3482.
}
