% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_jdate_options.R
\name{jdopt_set_valid_separators}
\alias{jdopt_set_valid_separators}
\title{setting new valid separators}
\usage{
jdopt_set_valid_separators(valid_separators)
}
\arguments{
\item{valid_separators}{character}
}
\value{
options list or warning
}
\description{
changing existing set of valid separators and defining a new set
}
\details{
Argument of the function is a character vector that each of elements has length of 0 or 1.
After changing 'VALID_SEPARATORS', if current 'DEFAULT_SEPARATOR' doesn't belong to new
'VALID_SEPARATORS', first element of new 'VALID_SEPARATORS' (after sorting) will be set as
'DEFAULT_SEPARATOR' and a message will be displayed.
}
\examples{
jdopt_reset()
res <- jdopt_set_valid_separators(c("+", "$"))
 #After setting new valid separators, the default separator was changed automatically!

res
# $DEFAULT_SEPARATOR
# [1] "$"
#
# $VALID_SEPARATORS
# [1] "$" "+"
#
# $MIN_YEAR
# [1] 1200
#
# $MAX_YEAR
# [1] 1500

}
