% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAIRCA.R
\name{apply.MAIRCA}
\alias{apply.MAIRCA}
\title{Apply Multi-Attributive Real Ideal Comparative Analysis (MAIRCA)}
\usage{
apply.MAIRCA(mat, weights, types)
}
\arguments{
\item{mat}{A numeric matrix. Rows are alternatives; columns are criteria.}

\item{weights}{A numeric vector of weights corresponding to criteria columns. Must sum to 1.}

\item{types}{An integer vector of the same length as \code{weights}. Use 1 for a profit criterion
and -1 for a cost criterion.}
}
\value{
A numeric vector with the MAIRCA preference values for each alternative.
Higher values indicate more preferred alternatives.
}
\description{
R implementation of the MAIRCA method.
The MAIRCA method computes the gap between ideal (theoretical) and empirical
ratings to rank alternatives.
}
\examples{
# Example usage
mat <- matrix(c(70, 245, 16.4, 19,
                52, 246, 7.3, 22,
                53, 295, 10.3, 25,
                63, 256, 12.0, 8,
                64, 233, 5.3, 17),
              nrow = 5, byrow = TRUE)
weights <- c(0.04744, 0.02464, 0.51357, 0.41435)
types <- c(1, 1, 1, 1)
apply.MAIRCA(mat, weights, types)
}
