% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WSM_WPM.R
\name{apply.WSM_WPM}
\alias{apply.WSM_WPM}
\title{Apply Weighted Sum Model (WSM) or Weighted Product Model (WPM) on data}
\usage{
apply.WSM_WPM(mat, beneficial.vector, weights, method = "WSM")
}
\arguments{
\item{mat}{is a matrix and contains the values for different properties
of different alternatives.}

\item{beneficial.vector}{is a vector that contains the column number of beneficial
properties.}

\item{weights}{are the weights of each property in the decision making process}

\item{method}{can either be 'WSM' or 'WPM', set to 'WSM' by default.}
}
\value{
a vector containing the calculated preference score, run rank(-apply.WSM(mat, beneficial.vector, weights))
to get the ranks.
}
\description{
Apply Weighted Sum Model (WSM) or Weighted Product Model (WPM) on data
}
\examples{
mat <- matrix(c(250, 200, 300, 275,
 225, 16, 16, 32,
  32, 16, 12, 8,
   16, 8, 16, 5,
    3, 4, 4, 2), nrow=5, ncol=4)
colnames(mat)<-c("Price", "Storage space",
 "Camera", "Looks")
rownames(mat)<-paste0("Mobile ", seq(1, 5, 1))
beneficial.vector <- c(2, 3, 4)
weights <- c(0.25, 0.25, 0.25, 0.25)
apply.WSM_WPM(mat, beneficial.vector, weights, "WSM")

}
