% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_real.R
\name{predict_real}
\alias{predict_real}
\title{Compute estimates of real parameters with individual and design covariates}
\usage{
predict_real(
  model,
  df,
  parameter,
  replicate = FALSE,
  beta = NULL,
  data = NULL,
  se = TRUE,
  vcv = FALSE
)
}
\arguments{
\item{model}{MARK model object}

\item{df}{design dataframe subset}

\item{parameter}{names of the parameter}

\item{replicate}{if FALSE then number of rows in data must match the number of rows in df}

\item{beta}{estimates of beta parameters for real parameter computation}

\item{data}{dataframe with covariate values}

\item{se}{if TRUE returns std errors and confidence interval of real
estimates}

\item{vcv}{logical; if TRUE, sets se=TRUE and returns v-c matrix of real
estimates}
}
\value{
A data frame (\code{real}) is returned if \code{vcv=FALSE};
otherwise, a list is returned also containing vcv.real: \item{real}{ data
frame containing estimates, and if se=TRUE or vcv=TRUE it also contains
standard errors and confidence intervals and notation of whether parameters
are fixed or at a boundary} \item{vcv.real}{variance-covariance matrix of
real estimates}
}
\description{
Unlike covariate.predictions this function allows modification of design data covariates
as well as individual covariates for the computation of the real parameters. It does
this by modifying values in the design data, adding individual covariate values to the 
design data and then applying the model formula to the modified design data to construct a 
design matrix that is used with the beta estimates to construct the real parameter estimates.
}
\details{
There are two restrictions. First,it only works with a single parameter type (eg Phi or p)
whereas covariate.predictions allows simultaneous estimation of multiple parameter types.
Second, if the row from df is a fixed parameter that will only be identified if it uses the fix
parameter in the design data. It will not work with the original approach of using index and fixed as
arguments. This should be a minor restrictioin because it doesn't make sense to compute a range of
real parameter values for a fixed parameter. 

The primary arguments are model which is a fitted mark model object and df which is one of 
the design dataframes from the design data list (ddl) used to fit the model. The value of
df can be a subset of the original design dataframe but do NOT create an arbitrary dataframe
for use as df because if you don't get the indices correct or you don't construct the factor
variables correctly, it will likely fail or the results could be bogus.  

The argument parameter is just the character name for the parameter ("Phi"). It is only used 
to extract the correct formula from the fitted model.

The argument beta can provide values for the beta coefficients other than the fitted ones but
if you do so, don't expect the variances to make sense as the beta.vcv is computed at the
fitted values.  The default for beta is to use the fitted values so it need not be specified.

The argument data is a dataframe containing values for individual covariates or replacement 
values for design data covariates.  Do not replace values of factor variables which probably 
would not make sense anyhow.  If replicate=FALSE then the number of rows in df must match the
number of rows in data and the values in df are replaced (if design covariate) or added if 
an individual covariate.  If replicate=TRUE, then design data (df) is replicated for each row 
in data and the values in data are computed for each one of the rows in df.  Using replicate=TRUE
would make sense in a case where the value can differ for the index. For example, if one of the 
design covariates was temperature then you might want to compute the values at a range of temperatures
for a row in the design data representing each age class in the data.

The arguments se and vcv control computation of the std errors and v-c matrix.
}
\examples{

data(dipper)
dp=process.data(dipper)
ddl=make.design.data(dp)
model=mark(dp,ddl,model.parameters=list(Phi=list(formula=~Time)),delete=TRUE)
predict_real(model,ddl$Phi[1,,drop=FALSE],"Phi",replicate=TRUE,data=data.frame(Time=-12:12))

}
\seealso{
\code{\link{inverse.link}},\code{\link{deriv_inverse.link}}
}
\author{
Jeff Laake
}
\keyword{utility}
