% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXTCOMP_methods.R
\name{plot.MixtCompLearn}
\alias{plot.MixtCompLearn}
\title{Plot of a \emph{MixtCompLearn} object}
\usage{
\method{plot}{MixtCompLearn}(
  x,
  nVarMaxToPlot = 3,
  nClass = NULL,
  pkg = c("ggplot2", "plotly"),
  plotData = c("CI", "Boxplot"),
  ...
)
}
\arguments{
\item{x}{\emph{MixtCompLearn} object}

\item{nVarMaxToPlot}{number of variables to display}

\item{nClass}{number of classes of the model to plot}

\item{pkg}{"ggplot2" or "plotly". Package used to plot}

\item{plotData}{"CI" or "Boxplot". If "CI", uses \link[RMixtCompUtilities]{plotDataCI} function. If "Boxplot", uses \link[RMixtCompUtilities]{plotDataBoxplot}}

\item{...}{extra parameter for \link[RMixtCompUtilities]{plotDataCI} or \link[RMixtCompUtilities]{plotDataBoxplot}}
}
\value{
\code{ggplot2} or \code{plotly} object
}
\description{
Plot of a \emph{MixtCompLearn} object
}
\examples{
data(iris)

# run RMixtComp in unsupervised clustering mode and in basic mode
resLearn <- mixtCompLearn(iris[, -5], nClass = 2:4, nCore = 1)

plot(resLearn)
plot(resLearn, nClass = 3, plotData = "Boxplot")

}
\seealso{
\code{\link{mixtCompLearn}} \code{\link{mixtCompPredict}}

Other plot: 
\code{\link{plotCrit}()}
}
\author{
Quentin Grimonprez
}
\concept{plot}
