% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXTCOMP_mixtCompLearn.R
\name{predict.MixtComp}
\alias{predict.MixtComp}
\title{Predict using RMixtComp}
\usage{
\method{predict}{MixtComp}(
  object,
  newdata = NULL,
  type = c("partition", "probabilities"),
  nClass = NULL,
  ...
)
}
\arguments{
\item{object}{output of \link{mixtCompLearn} function.}

\item{newdata}{a data.frame, a matrix or a named list containing the data (see \emph{Details} and \emph{Data format}
sections in \link{mixtCompLearn} documentation). If \code{NULL}, use the data in \code{object}.}

\item{type}{if "partition", returns the estimated partition. If "probabilities", returns the probabilities to belong to
each class (tik).}

\item{nClass}{the number of classes of the mixture model to use from \code{object}. If \code{NULL}, uses the number
maximizing the criterion.}

\item{...}{other parameters of \link{mixtCompPredict} function.}
}
\value{
if \code{type = "partition"}, it returns the estimated partition as a vector. If \code{type = "probabilities"},
it returns the probabilities to belong to each class (tik) as a matrix.
}
\description{
Predict the cluster of new samples.
}
\details{
This function is based on the generic method "predict". For a more complete output, use \link{mixtCompPredict}
function.
}
\examples{
data(iris)

model <- list(
  Sepal.Length = "Gaussian", Sepal.Width = "Gaussian",
  Petal.Length = "Gaussian", Petal.Width = "Gaussian"
)

resLearn <- mixtCompLearn(iris[-c(1, 51, 101), ], model = model, nClass = 1:3, nRun = 1)

# return the partition
predict(resLearn)

# return the tik for the 3 new irises for 2 and 3 classes
predict(resLearn, newdata = iris[c(1, 51, 101), ], type = "probabilities", nClass = 2)
predict(resLearn, newdata = iris[c(1, 51, 101), ], type = "probabilities", nClass = 3)

}
\seealso{
\link{mixtCompPredict}
}
\author{
Quentin Grimonprez
}
