% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NestedX.R
\name{NestedX}
\alias{NestedX}
\title{Constructing nested design sets for the RNA model.}
\usage{
NestedX(n, d)
}
\arguments{
\item{n}{A vector specifying the number of design points at each fidelity level \eqn{l}. Thus, the vector must have a positive value \eqn{n_1, \ldots, n_l} where \eqn{n_1 > \cdots > n_l}.}

\item{d}{A positive integer specifying the dimension of the design.}
}
\value{
A list containing the nested design sets at each level, i.e., \eqn{\mathcal{X}_{1}, \ldots, \mathcal{X}_{l}}.
}
\description{
The function constructs nested design sets with multiple fidelity levels
\eqn{\mathcal{X}_l \subseteq \cdots \subseteq \mathcal{X}_{1}} for use in \code{\link{RNAmf}}.
}
\details{
The procedure replace the points of lower level design \eqn{\mathcal{X}_{l-1}}
with the closest points from higher level design \eqn{\mathcal{X}_{l}}.
For details, see "\href{https://github.com/cran/MuFiCokriging}{\code{NestedDesign}}".
}
\examples{
### number of design points ###
n1 <- 30
n2 <- 15

### dimension of the design ###
d <- 2

### fix seed to reproduce the result ###
set.seed(1)

### generate the nested design ###
NX <- NestedX(c(n1, n2), d)

### visualize nested design ###
plot(NX[[1]], col="red", pch=1, xlab="x1", ylab="x2")
points(NX[[2]], col="blue", pch=4)

}
\references{
L. Le Gratiet and J. Garnier (2014). Recursive co-kriging model for design of computer experiments
with multiple levels of fidelity. \emph{International Journal for Uncertainty Quantification}, 4(5), 365-386;
\doi{doi:10.1615/Int.J.UncertaintyQuantification.2014006914}
}
