% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_expression.R
\name{plot_sample_MAs}
\alias{plot_sample_MAs}
\title{MA plots of samples}
\usage{
plot_sample_MAs(vsd, group, y_lim = 3, rasterise = FALSE, ...)
}
\arguments{
\item{vsd}{An object generated by \code{DESeq2::vst()}}

\item{group}{A grouping variable, must be a column of \code{colData(vsd)}}

\item{y_lim}{Y-axis limits, the axis will run from \code{-y_lim} to \code{y_lim}}

\item{rasterise}{Whether to rasterise the points using ggrastr.}

\item{...}{Other parameters passed on to ggrastr::rasterise}
}
\value{
A list of ggplot objects of the ggplot2 package, with each element corresponding to one MA-plot.
}
\description{
For each level of the grouping variable, the gene-wise median over all samples is computed
to obtain a reference sample. Then, each sample is plotted against the reference.
}
\examples{
library("DESeq2")
set.seed(1)
dds <- makeExampleDESeqDataSet(n=1000, m=4, interceptMean=10)
colData(dds)$type <- c("A","A","B","B")
vsd <- vst(dds)
plot_sample_MAs(vsd, group="type")

}
